// Copyright (C) 2012 Shuny.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, version 2.0.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License 2.0 for more details.

// A copy of the GPL 2.0 should have been included with the program.
// If not, see http://www.gnu.org/licenses/

#include <iostream>
#include <algorithm>
#include <fstream>

#define TARGET_SIZE 139264
#define LIMIT_SIZE 8192 // May requires tweaking

bool isRawSaveFile(long savFileSize)
{
	return (((savFileSize & (savFileSize - 1)) == 0) && (savFileSize != 0) && savFileSize < TARGET_SIZE);
}

long getFileSize(std::ifstream& handle)
{
	long fileSize;

	handle.seekg(0, std::ifstream::end);
	fileSize = handle.tellg();
	handle.seekg(0, std::ifstream::beg);

	return (fileSize);
}

int startConversion(char* savInputPath, char* savOutputPath)
{
	std::ifstream savHandle;
	std::ofstream outputHandle;
	long savFileSize;
	char* savBuffer;

	savHandle.open(savInputPath, std::ifstream::binary);
	if (!savHandle)
	{
		std::cerr << "Error: Cannot open file " << savInputPath << std::endl;
		return (1);
	}
	
	savFileSize = getFileSize(savHandle);
	if (!isRawSaveFile(savFileSize))
	{
		std::cerr << "Error: The file is not a RAW GBA save file" << std::endl;
		return (1);
	}

	savBuffer = new char[TARGET_SIZE];
	std::fill(savBuffer, savBuffer + TARGET_SIZE, 0xFF);

	if (savFileSize <= LIMIT_SIZE)
		savHandle.read(savBuffer + (TARGET_SIZE - LIMIT_SIZE), savFileSize);
	else
		savHandle.read(savBuffer, savFileSize);

	savHandle.close();

	outputHandle.open(savOutputPath, std::ofstream::binary);
	if (!outputHandle)
	{
		std::cerr << "Error: Cannot open file " << savOutputPath << std::endl;
		delete[] savBuffer;
		return (1);
	}
	outputHandle.write(savBuffer, TARGET_SIZE);
	outputHandle.close();

	delete[] savBuffer;
	return (0);
}

int main(int argc, char** argv)
{
	if (argc < 2 || argc > 3)
	{
		std::cout << "K1 GBA SP Savegame converter v1.01 - Shuny" << std::endl;
		std::cout << "Usage: " << argv[0] << " source_savegame [output_savegame]" << std::endl;
		return (1);
	}

	else if (argc == 2)
		return (startConversion(argv[1], argv[1]));

	return (startConversion(argv[1], argv[2]));
}

